/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor;

import com.quantumdata.fmteditor.FmtEditorMain;
import com.quantumdata.fmteditor.InstrumentListener;
import com.quantumdata.fmteditor.TextEditorFrame;
import com.quantumdata.fmteditor.fmtwidgets.ConnectPanel;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftpbrowser.FtpBrowser;
import com.quantumdata.ftpbrowser.FtpBrowserPlugIn;
import com.quantumdata.ftpbrowser.FtpOpenHandler;
import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class FtpBrowserFrame
extends FmtFrameBase
implements InstrumentListener {
    private static int m_ftpCnt = 0;
    private FtpBrowserPlugIn m_plugin;
    private FtpBrowser m_browser;
    private ConnectPanel m_con;
    private int m_id = ++m_ftpCnt;

    public FtpBrowserFrame(IQDPluginContext iQDPluginContext) {
        super("", true, true, true, true);
        this.m_plugin = new FtpBrowserPlugIn();
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        this.m_browser = (FtpBrowser)this.m_plugin.getTopPanel(iQDPluginContext);
        qDPanel.add((Component)this.m_browser, (Object)"Center");
        this.m_con = new ConnectPanel((JComponent)((Object)this));
        this.m_con.useCompactForm(true);
        qDPanel.add((Component)((Object)this.m_con), (Object)"North");
        this.getContentPane().add((Component)qDPanel);
        this.m_con.setListener(this);
        this.m_browser.setOpenHandler(new OpenHandler());
    }

    public void connected(RemoteInstrument remoteInstrument) {
        this.m_browser.setInstrument(remoteInstrument);
        this.setFrameTitle();
    }

    public void disconnected(RemoteInstrument remoteInstrument) {
        this.m_browser.setInstrument(null);
        this.setFrameTitle();
    }

    public void start() {
        this.m_browser.setInstrument(this.m_con.getInstrument());
        this.setFrameTitle();
    }

    public String getDataName() {
        return "";
    }

    public String getTypeName() {
        return "FTP Browser #" + this.m_id;
    }

    public void setFrameTitle() {
        RemoteInstrument remoteInstrument = this.getInstrument();
        if (remoteInstrument != null) {
            this.setFrameTitle(this.getTypeName() + " (" + remoteInstrument.getConnection().getName() + ")");
        } else {
            this.setFrameTitle(this.getTypeName());
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isSaveable() {
        return false;
    }

    public void markUnmodified() {
    }

    public RemoteInstrument getInstrument() {
        return this.m_con.getInstrument();
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_con.setInstrument(remoteInstrument);
    }

    public boolean isLocalFile() {
        return true;
    }

    public boolean supportsRemoteFiles() {
        return false;
    }

    public String getOptTitleText() {
        RemoteInstrument remoteInstrument = this.getInstrument();
        if (remoteInstrument != null && remoteInstrument.isConnected()) {
            return " (" + remoteInstrument.getConnection().getName() + ")";
        }
        return "";
    }

    public void frameClosing() {
        this.m_con.close();
    }

    class OpenHandler
    implements FtpOpenHandler {
        OpenHandler() {
        }

        public int openFile(CoFile coFile) {
            if (this.isOpenAllowed(coFile)) {
                TextEditorFrame textEditorFrame = new TextEditorFrame(coFile);
                FmtEditorMain.instance().addFrame(textEditorFrame);
                return 1;
            }
            return -1;
        }

        public boolean isOpenAllowed(CoFile coFile) {
            if (coFile == null) {
                return false;
            }
            String[] stringArray = new String[]{".XML", ".TXT"};
            return coFile.equalsExtTo(stringArray);
        }
    }
}

